/*
 * plcnvm
 *
 * PLC NVM manager for slave PLC chips.
 * Common definitions.
 *
 * Boots an external PLC chip loading a PLC firmware image through Ethernet
 *
 * Copyright (C) 2015, Broadcom Corporation. All Rights Reserved.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */


#ifndef _PLCNVM_COMMON_H_
#define _PLCNVM_COMMON_H_


/************************************************
 *                   Defines
 ************************************************/

/* NVMFwPkts protocol command mask */
#define NVMFWPKTS_SUBTYPE_CMD_MASK     (0x0C)

 /* NVMFwPkts protocol subtype. FS_OPEN.REQ */
#define NVMFWPKTS_SUBTYPE_FSOPEN_REQ   (0x00)
/* NVMFwPkts protocol subtype. FS_OPEN.CNF */
#define NVMFWPKTS_SUBTYPE_FSOPEN_CNF   (0x01)
/* NVMFwPkts protocol subtype. FS_OPEN.IND */
#define NVMFWPKTS_SUBTYPE_FSOPEN_IND   (0x02)
/* NVMFwPkts protocol subtype. FS_CLOSE.REQ */
#define NVMFWPKTS_SUBTYPE_FSCLOSE_REQ  (0x04)
/* NVMFwPkts protocol subtype. FS_CLOSE.CNF */
#define NVMFWPKTS_SUBTYPE_FSCLOSE_CNF  (0x05)
/* NVMFwPkts protocol subtype. FS_CLOSE.IND */
#define NVMFWPKTS_SUBTYPE_FSCLOSE_IND  (0x06)
/* NVMFwPkts protocol subtype. FS_READ.REQ */
#define NVMFWPKTS_SUBTYPE_FSREAD_REQ   (0x08)
/* NVMFwPkts protocol subtype. FS_READ.CNF */
#define NVMFWPKTS_SUBTYPE_FSREAD_CNF   (0x09)
/* NVMFwPkts protocol subtype. FS_READ.IND */
#define NVMFWPKTS_SUBTYPE_FSREAD_IND   (0x0A)
/* NVMFwPkts protocol subtype. FS_READ.REQ */
#define NVMFWPKTS_SUBTYPE_FSWRITE_REQ  (0x0C)
/* NVMFwPkts protocol subtype. FS_READ.CNF */
#define NVMFWPKTS_SUBTYPE_FSWRITE_CNF  (0x0D)
/* NVMFwPkts protocol subtype. FS_READ.IND */
#define NVMFWPKTS_SUBTYPE_FSWRITE_IND  (0x0E)
/* NVMFwPkts protocol subtype. FACTORY_RESET.REQ */
#define NVMFWPKTS_SUBTYPE_FACTORY_RESET_REQ  (0x10)
/* NVMFwPkts protocol subtype. FACTORY_RESET.CNF */
#define NVMFWPKTS_SUBTYPE_FACTORY_RESET_CNF  (0x11)
/* NVMFwPkts protocol subtype. SET_MAC.REQ */
#define NVMFWPKTS_SUBTYPE_SET_MAC_REQ  (0x14)
/* NVMFwPkts protocol subtype.  SET_MAC.CNF */
#define NVMFWPKTS_SUBTYPE_SET_MAC_CNF  (0x15)
/* NVMFwPkts protocol subtype.  SET_MAC.IND */
#define NVMFWPKTS_SUBTYPE_SET_MAC_IND  (0x16)
/* NVMFwPkts protocol subtype. SET_IP.REQ */
#define NVMFWPKTS_SUBTYPE_SET_IP_REQ  (0x18)
/* NVMFwPkts protocol subtype.  SET_IP.CNF */
#define NVMFWPKTS_SUBTYPE_SET_IP_CNF  (0x19)
/* NVMFwPkts protocol subtype.  SET_IP.IND */
#define NVMFWPKTS_SUBTYPE_SET_IP_IND  (0x1A)
/* NVMFwPkts protocol subtype.  GPHY_DOWN.REQ */
#define NVMFWPKTS_SUBTYPE_GPHY_DOWN_REQ  (0x1C)
/* NVMFwPkts protocol subtype.  GPHY_DOWN.CNF */
#define NVMFWPKTS_SUBTYPE_GPHY_DOWN_CNF  (0x1D)
/* NVMFwPkts protocol subtype.  GPHY_DOWN.IND */
#define NVMFWPKTS_SUBTYPE_GPHY_DOWN_IND  (0x1E)


/* NVMFwPkts header fields size (in bytes). PID field */
#define NVMFWPKTS_HEADER_PID_SIZE      (0x02)
/* NVMFwPkts header fields size (in bytes). Address field */
#define NVMFWPKTS_HEADER_ADDRESS_SIZE  (0x04)
/* NVMFwPkts header fields size (in bytes). Length field */
#define NVMFWPKTS_HEADER_LENGTH_SIZE   (0x04)


/************************************************
 *               Debug utilities
 ************************************************/

//#define DBG_CONSOLE_LOG
//#define DBG_COUNTERS

#ifdef DBG_CONSOLE_LOG
#define DBG_LOG(format, ...) do { \
	printf("PLCNVM (DBG): %s(%u) - " format "\n" , __func__, __LINE__,  ##__VA_ARGS__); \
} while(0)
#else
#define DBG_LOG(format, ...)
#endif

#define INFO_LOG(format, ...) do { \
	printf("[PLCNVM] " format "\n" ,  ##__VA_ARGS__ ); \
} while(0)

#define ERROR_LOG(format, ...) do { \
	printf("PLCNVM (ERROR): %s(%u) - " format "\n" , __func__, __LINE__,  ##__VA_ARGS__); \
} while(0)

#endif /* _PLCNVM_COMMON_H_ */
